#!/bin/sh
#### "*******************************************"
#### "              Created By RAED              *"
#### "*        << Edited by  MOHAMED_OS >>       *"
#### "*        ..:: www.tunisia-sat.com ::..     *"
#### "*******************************************"
CAMNAME="OSCam_11.701-r798"
CAMBIN=oscam
LINE="--------------------------------------"
INFOFILE="ecm.info"
SCRIPT="OScam.sh"
# end

remove_tmp () {
	rm -rf /tmp/ecm.info /tmp/script.info  /tmp/pid.info /tmp/cardinfo /tmp/cam.info /tmp/debug.txt /tmp/ecm0.info /tmp/mbox.ver /tmp/newcs.pid /tmp/share.info /tmp/share.onl /tmp/stat.info
}

case "$1" in
     start)
	if [ -f /tmp/script.info ]; then
           RUNNING_SCRIPT=`cat /tmp/script.info`
	else
           RUNNING_SCRIPT=$SCRIPT
        fi
	/usr/script/$RUNNING_SCRIPT stop
	sleep 2
        echo $LINE
	echo "[SCRIPT] $1: $CAMNAME"
        echo $LINE
	remove_tmp
	echo $SCRIPT > /tmp/script.info
        echo $CAMNAME > /tmp/cam.info
	/usr/camd/$CAMBIN >/dev/null 2>&1 &
        ;;
     stop)
	echo $LINE
	echo "[SCRIPT] $1: $CAMNAME"
        echo $LINE
	killall -9 $CAMBIN 2>/dev/null
	sleep 2
	remove_tmp
	;;
     restart)
	echo $LINE
	echo "[SCRIPT] $1: $CAMNAME"
        echo $LINE
	killall -9 $CAMBIN 2>/dev/null
	sleep 2
	remove_tmp
	sleep 15
	echo $SCRIPT > /tmp/script.info
        echo $CAMNAME > /tmp/cam.info
	/usr/camd/$CAMBIN >/dev/null 2>&1 &
	;;
     info)
        echo $LINE
	echo "[SCRIPT] $1: $CAMNAME"
        echo $LINE
        if [ -f /tmp/cam.info ]; then
           RUNNING_CAM=`cat /tmp/cam.info`
        else
           RUNNING_CAM="no CAM"
        fi
        echo -n "$RUNNING_CAM  is started "
        if [ `ps ax | grep $CAMBIN | grep -v grep | grep -v $0 | wc -l` -gt 0 ]; then
           echo "and running"
           echo $LINE
           ps ax | grep $CAMBIN | grep -v grep | grep -v $0
        else
           echo "but not running"
        fi
        echo $LINE
        # check newcs also
        #if [ `ps ax | grep oscam | grep -v grep | grep -v $0 | wc -l` -gt 0 ]; then
        #   echo "and oscam is running"
        #   echo $LINE
        #   ps ax | grep oscam | grep -v grep | grep -v $0
        #else
        #   echo "and oscam is not running"
        #fi
        #echo $LINE

        if [ ! -f /etc/rc3.d/S99camd.sh ]; then
           echo "autostart is disabled"
           echo $LINE
        else
           if [ `ls -al /etc/rc3.d/S99camd.sh | grep $CAMBIN.sh | wc -l` -gt 0 ]; then
              echo "autostart of $CAMNAME is enabled"
              echo $LINE
           else
              echo "autostart of $CAMNAME is disabled"
              echo $LINE
           fi
        fi

        if [ -f /tmp/ecm.info ]; then
           echo "ECM info"
           echo $LINE
	   cat /tmp/ecm.info
           echo $LINE
        fi
        if [ -f /tmp/cardinfo ]; then
           echo "Card info"
           echo $LINE
	   cat /tmp/cardinfo
           echo $LINE
        fi
	;;
     autostart | enable)
        echo $LINE
	echo "[SCRIPT] $1: $CAMNAME"
        echo $LINE
        ln -sfn /usr/script/$CAMBIN.sh /etc/rc3.d/S99camd.sh
	;;
     noautostart | disable)
        echo $LINE
	echo "[SCRIPT] $1: $CAMNAME"
        echo $LINE
        rm /etc/rc3.d/S99camd.sh > /dev/null 2>&1
	;;
     *)
	echo "Usage: $0 start|stop|restart|info|enable|disable"
	exit 1
	;;
esac

exit 0
